<?php

global $amike_opt;

$amike_preloader = !empty( $amike_opt['amike_preloader'] ) ? $amike_opt['amike_preloader'] : '';
$amike_blog_title = !empty( $amike_opt['amike_blog_title'] ) ? $amike_opt['amike_blog_title'] : esc_html__( 'Latest Blog', 'amike' );

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" integrity="sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p" crossorigin="anonymous"/>


	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>

	<?php if ( true == $amike_preloader ): ?>
		<!-- Preloading -->
	    <div id="preloader">
	        <div class="spinner">
	        	<div class="uil-ripple-css" style="transform:scale(0.29);"><div></div><div></div></div>
	        </div>
	    </div>
	<?php endif ?>
	
	<!-- site header -->
	<header>
		<nav class="navbar navbar-expand-lg">
			<div class="container">
				<?php if ( ! has_custom_logo() ) { ?>
					<a class="navbar-logo" rel="home" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" itemprop="url"><?php bloginfo( 'name' ); ?></a>

				<?php } else {
					the_custom_logo();
				}?>
				<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
				<span class="navbar-toggler-icon"></span>
				</button>
				<div class="collapse navbar-collapse hellog" id="navbarSupportedContent">
                <div class="toggle-logo">
                <img src="https://tanzilch.com/wp-content/uploads/2020/11/tanzilch-logo.png">
                
                </div>
                <span class="cross-nav">
                <i class="fas fa-times"></i>
                </span>
					<?php
						wp_nav_menu( array(
						'theme_location'    => 'primary',
						'depth'             => 2,
						'container'         => 'ul',
						'menu_class'        => 'navbar-nav ml-auto',
						'walker'            => new amike_WP_Bootstrap_Navwalker(),
					) );
					?>
				</div>
			</div>
		</nav>
	</header>


	<?php if (!is_page_template( 'custom-homepage.php' )) { ?>
		<section class="breadcrumb-header text-center">
			<div class="container">
				<div class="title-header">
					<h1>
			          <?php
			              if(is_home() && is_front_page()){

			              	echo esc_html( $amike_blog_title );

			              } elseif(is_home()) {

			              	echo esc_html( $amike_blog_title );

			              } else {

			              	wp_title('');
			              }
			          ?>
			        </h1>
					<?php amike_breadcrumb(); ?>					
				</div>			
			</div>
		</section>
	<?php } ?>