<?php

global $amike_opt;

$amike_footer_top = !empty( $amike_opt['amike_footer_top'] ) ? $amike_opt['amike_footer_top'] : '';
$amike_footer_logo = !empty( $amike_opt['amike_footer_logo'] ) ? $amike_opt['amike_footer_logo'] : '';
$amike_copyright_info = !empty( $amike_opt['amike_copyright_info'] ) ? $amike_opt['amike_copyright_info'] : esc_html__( 'Copyright 2020 All right reserved by ThemeBing', 'amike' );
$amike_footer_text = !empty( $amike_opt['amike_footer_text'] ) ? $amike_opt['amike_footer_text'] : '';
$amike_footer_social_icons = !empty( $amike_opt['amike_footer_social_icons'] ) ? $amike_opt['amike_footer_social_icons'] : '';
?>


	<footer class="text-center">
		<?php if ( true == $amike_footer_top ): ?>
		<div class="site-footer">
			<div class="container">
				<div class="row justify-content-center">
					<div class="col-lg-9 col-sm-10 mb-4">
						<?php if ( true == $amike_footer_logo ): ?>
							<div class="mb-5">
								<?php if ( ! has_custom_logo() ) { ?>
								<a class="navbar-logo" rel="home" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" itemprop="url"><?php bloginfo( 'name' ); ?></a>

								<?php } else {
									the_custom_logo();
								}?>
							</div>
						<?php endif ?>
						<?php if ($amike_footer_text): ?>
							<p class="footer-text"><?php echo esc_html( $amike_footer_text ) ?></p>
						<?php endif ?>						
						<div class="footer-social">
							<ul class="list-inline">
								<?php 
				                foreach( $amike_footer_social_icons as $key => $value ) { 
				                	if($value!=''){ ?>
				                    <li class="list-inline-item">
				                    	<a href="<?php echo esc_attr( $value ); ?>" target="_blank"><i class="fa fa-<?php echo esc_attr( $key ); ?>"></i></a>
				                    </li>
					                <?php }
					            } ?>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php endif ?>


		<div class="copyright-text">
			<?php
		    if( $amike_copyright_info ) {
		        echo wp_kses( $amike_copyright_info , array(
		            'a'       => array(
		                'href'    => array(),
		                'title'   => array()
		            ),
		            'br'      => array(),
		            'em'      => array(),
		            'strong'  => array(),
		            'img'     => array(
		                'src' => array(),
		                'alt' => array()
		            ),
		        ));
		    } else { ?>
		    <p><?php echo esc_html__( 'Copyright 2020 All right reserved by ThemeBing','amike' );?></p>
		    <?php } ?>
		</div>
	</footer>
	
	<div id="backtotop"><i class="fa fa-2x fa-rocket"></i></div>
	
	<?php wp_footer(); ?>

	</body>
</html>
