<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package amike
 */
global $amike_opt;
$amike_excerpt_length = !empty( $amike_opt['amike_excerpt_length'] ) ? $amike_opt['amike_excerpt_length'] : 32;
?>

<?php if (is_singular()) { ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="entry-content">
			<?php if (has_post_thumbnail()): ?>
			<div class="single-post-image">
				<?php the_post_thumbnail('amike-single-page-image') ?>
			</div>
			<?php endif ?>
			<?php
			the_content( sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'amike' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'amike' ),
				'after'  => '</div>',
			) );
			?>
			<?php if (has_tag()): ?>				
				<span class="post-tag">
				<?php echo esc_html__('Tags : ', 'amike') . get_the_tag_list('', esc_html_x(' ', 'list item separator', 'amike'));?>
				</span>
			<?php endif ?>

		</div><!-- .entry-content -->
	</article><!-- #post-<?php the_ID(); ?> -->

<?php } else { ?>

	<div id="post-<?php the_ID(); ?>" <?php post_class('post-item'); ?>>
		<?php if (has_post_thumbnail()): ?>
			<div class="post-item-image">
				<a href="<?php the_permalink() ?>"><?php the_post_thumbnail( 'amike-team-1280x600', ['class' => 'img-fluid']) ?></a>			
			</div>
		<?php endif ?>
		<div class="post-item-content row">	
			<div class="col-md-12">
				<span><i class="fa fa-user"></i> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" class="link"><?php the_author(); ?></a><i class="fa ml-4 fa-calendar-o"></i><?php echo get_the_date() ?></span>

				<a href="<?php the_permalink() ?>">
					<?php the_title( '<h3>', '</h3>' ) ?>
				</a>
				<p><?php echo wp_trim_words( get_the_excerpt(), $amike_excerpt_length, '.' ); ?></p>
			</div>
		</div>
	</div>
	
<?php } ?>
