<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    $opt_name = "amike_opt";
    $theme = wp_get_theme();

    $args = array(
        'opt_name'             => $opt_name,
        'display_name'         => $theme->get( 'Name' ),
        'display_version'      => $theme->get( 'Version' ),
        'menu_type'            => 'menu',
        'allow_sub_menu'       => true,
        'menu_title'           => esc_html__( 'Amike Options', 'amike' ),
        'page_title'           => esc_html__( 'Amike Options', 'amike' ),
        'google_api_key'       => '',
        'google_update_weekly' => false,
        'async_typography'     => false,
        'admin_bar'            => true,
        'admin_bar_icon'       => 'dashicons-portfolio',
        'admin_bar_priority'   => 50,
        'global_variable'      => '',
        'dev_mode'             => false,
        'update_notice'        => false,
        'customizer'           => true,
        'page_priority'        => null,
        'page_parent'          => 'themes.php',
        'page_permissions'     => 'manage_options',
        'menu_icon'            => '',
        'last_tab'             => '',
        'page_icon'            => 'icon-themes',
        'page_slug'            => '_options',
        'save_defaults'        => true,
        'default_show'         => false,
        'default_mark'         => '',
        'show_import_export'   => true,
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        'output_tag'           => true,
        'database'             => '',
        'use_cdn'              => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    Redux::setArgs( $opt_name, $args );

    // Style
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Style', 'amike' ),
        'id'     => 'amike_style',
        'icon'   => 'el el-heart-empty',
        'fields' => array(
            array(
                'id'          => 'amike_preloader',
                'type'        => 'switch',
                'title'       => esc_html__( 'Preloader', 'amike' ),
                'default'  => true
            ), 
            array(
                'id'       => 'amike_primary_color',
                'type'     => 'color',
                'title'    => esc_html__('Primary Color', 'amike'), 
                'subtitle' => esc_html__('Pick a primary color.', 'amike'),
                'default'  => '#FF6913',
                'validate' => 'color',
            ),
        )
    ) );    

    // Typography
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Typography', 'amike' ),
        'id'               => 'amike_page_title_typography',  
        'icon'   => 'el el-pencil',
        'fields'           => array(
       
            array(
                'id'          => 'amike_typography',
                'type'        => 'typography',
                'title'       => esc_html__( 'Typography', 'amike' ),
                'subtitle'    => esc_html__('body, p Tags, Heading', 'amike'),
                'google'      => true, 
                'font-backup' => true,
                'output'      => array('body,p'),
                'units'       =>'px',
                'default'     => array(
                    'color'       => '#dfdfdf',
                    'font-weight'  => 'normal', 
                    'font-family' => 'Poppins', 
                    'line-height' => '26px',
                    'google'      => true,
                    'font-size'   => '16px',
                ),
            )
        )
    ) );

    // Blog
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Blog', 'amike' ),
        'id'    => 'blog',
        'icon'  => 'el el-wordpress',
    ));

    // Blog Page
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Blog Page', 'amike' ),
        'id'    => 'amike_blog_page',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'amike_blog_title',
                'type'     => 'text',
                'title'    => esc_html__( 'Breadcrumb Title', 'amike' ),
                'default'  => esc_html__( 'Latest Blog', 'amike' ),
            ),
            array(
                'id'               => 'amike_excerpt_length',
                'type'             => 'slider',
                'title'            => esc_html__('Excerpt Length', 'amike'),
                'subtitle'         => esc_html__('Controls the excerpt length on blog page','amike'),
                "default"          => 32,
                "min"              => 10,
                "step"             => 2,
                "max"              => 130,
                'display_value'    => 'text'
            )
            
        )
    ) );

    // Single Blog
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Single Blog Page', 'amike' ),
        'id'    => 'amike_single_blog_page',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'amike_blog_details_post_navigation',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Navigation (Next/Previous)', 'amike' ),
                'default'  => true,
            )
        )
    ) );
    
    // Footer
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Footer', 'amike' ),
        'id'     => 'amike_footer',
        'icon'   => 'el el-arrow-down',
        'fields' => array( 

            array(
                'id'          => 'amike_footer_top',
                'type'        => 'switch',
                'title'       => esc_html__( 'Footer', 'amike' ),
                'default'  => false,
            ),

            array(
                'id'          => 'amike_footer_logo',
                'type'        => 'switch',
                'title'       => esc_html__( 'Footer logo', 'amike' ),
                'default'  => true,
                'required'    => array( 'amike_footer_top','equals', true )
            ),

            array(
                'id'              => 'amike_footer_text',
                'type'            => 'textarea',
                'title'           => esc_html__( 'Footer text', 'amike' ),
                'default'         => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor inci- didunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exe- rcitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 'amike' ),
                'required'    => array( 'amike_footer_top','equals', true )
            ),

            array(
                'id'       => 'amike_footer_social_icons',
                'type'     => 'sortable',
                'title'    => esc_html__('Social Icons', 'amike'),
                'subtitle' => esc_html__('Enter social links at top bar.', 'amike'),
                'desc'     => esc_html__('Drag/drop to re-arrange', 'amike'),
                'mode'     => 'text',
                'options'  => array(
                    'facebook'     => 'facebook',
                    'twitter'     => 'twitter',
                    'instagram' => 'instagram',
                    'pinterest'     => 'pinterest',
                    'google-plus'     => 'google-plus',
                    'tumblr'     => 'tumblr',
                    'linkedin'     => 'linkedin',
                    'behance'     => 'behance',
                    'dribbble'     => 'dribbble',
                    'youtube'     => 'youtube',
                    'vimeo'     => 'vimeo',
                    'rss'     => 'rss',
                ),
                'default' => array(
                    'facebook'      => 'http://facebook.com/',
                    'twitter'       => 'https://twitter.com/',
                    'instagram'     => 'https://www.instagram.com/',
                    'pinterest'     => 'https://uk.pinterest.com/',
                    'google-plus'   => '',
                    'tumblr'        => '',
                    'linkedin'      => '',
                    'behance'       => '',
                    'dribbble'      => '',
                    'youtube'       => '',
                    'vimeo'         => '',
                    'rss'           => '',
                ),                
                'required'    => array( 'amike_footer_top','equals', true ),
            ),

            array(
                'id'              => 'amike_copyright_info',
                'type'            => 'editor',
                'title'           => esc_html__( 'Copyright text', 'amike' ),
                'subtitle'        => esc_html__( 'Enter your company information here. HTML tags allowed: a, br, em, strong', 'amike' ),
                'default'         => esc_html__( 'Copyright © 2020 ', 'amike' ).'<a href="#">'.esc_html__('Mr. Me', 'amike' ).'</a>'.esc_html__(' All Rights Reserved by ThemeBing.', 'amike' ),
                'args'            => array(
                    'wpautop'         => false,
                    'teeny'           => true,
                    'textarea_rows'   => 5
                )
            )
        )
    ) );

    // 404 
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( '404 Error', 'amike' ),
        'id'     => 'error-page',
        'icon'   => 'el el-error-alt',
        'fields' => array(
            array(
                'id'          => 'amike_error_title',
                'type'        => 'text',
                'title'       => esc_html__( 'Error title', 'amike' ),
                'default'     => esc_html__( 'Oops! That page can’t be found.', 'amike' ),
                ),
            array(
                'id'          => 'amike_error_text',
                'type'        => 'textarea',
                'title'       => esc_html__('Error message', 'amike'),
                'subtitle'    => esc_html__('Enter "not found" error message.', 'amike'),
                'default'     => esc_html__('It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'amike'),
                )
            ),
    ) );
