<?php

// Files Includes
include_once get_theme_file_path('/inc/theme-option.php');
include_once get_theme_file_path('/inc/class-tgm-plugin-activation.php');
include_once get_theme_file_path('/inc/class-wp-bootstrap-navwalker.php');
include_once get_theme_file_path('/inc/breadcrumbs.php');
include_once get_theme_file_path('/inc/inline-script.php');
include_once get_theme_file_path('/inc/activate-license.php');

// amike setup
if ( ! function_exists( 'amike_setup' ) ) :

	function amike_setup() {

		load_theme_textdomain( 'amike', get_template_directory() . '/languages' );

		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'post-thumbnails' );

		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'amike' ),
		) );

		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		add_theme_support( 'custom-background', apply_filters( 'amike_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );

		add_image_size( 'amike-single-page-image', 1280,720, true );
		add_image_size( 'amike-team-250x250', 250,250, true );
		add_image_size( 'amike-80x80', 80,80, true );
		add_image_size( 'amike-100x100', 100,100, true );
		add_image_size( 'amike-team-1280x600', 1280,600, true );
	}
endif;
add_action( 'after_setup_theme', 'amike_setup' );

// content width
function amike_content_width() {
	
	$GLOBALS['content_width'] = apply_filters( 'amike_content_width', 640 );
}
add_action( 'after_setup_theme', 'amike_content_width', 0 );

// Register widget area
function amike_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'amike' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'amike' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );
}
add_action( 'widgets_init', 'amike_widgets_init' );

// Enqueue scripts and styles.
function amike_scripts() {
	wp_enqueue_style( 'amike-fonts', "//fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900&display=swap", wp_get_theme()->get( 'Version' ), 'screen' );
	wp_enqueue_style( 'bootstrap', get_stylesheet_directory_uri() . '/css/bootstrap.min.css');
	wp_enqueue_style( 'font-awesome', get_stylesheet_directory_uri() . '/css/font-awesome.min.css');
	wp_enqueue_style( 'magnific-popup', get_stylesheet_directory_uri() . '/css/magnific-popup.css');
	wp_enqueue_style( 'slick', get_stylesheet_directory_uri() . '/css/slick.css');
	wp_enqueue_style( 'animate', get_stylesheet_directory_uri() . '/css/animate.min.css');
	wp_enqueue_style( 'amike-style', get_stylesheet_uri() );


	wp_enqueue_script( 'bootstrap', get_theme_file_uri('/js/bootstrap.min.js') , array('jquery'), '20151215', true );
	wp_enqueue_script( 'magnific-popup', get_theme_file_uri('/js/jquery.magnific-popup.min.js') , array('jquery'), '20151215', true );
	wp_enqueue_script( 'isotope', get_theme_file_uri('/js/isotope.pkgd.min.js') , array('jquery'), '20151215', true );
	wp_enqueue_script( 'slick', get_theme_file_uri('/js/slick.min.js') , array('jquery'), '20151215', true );
	wp_enqueue_script( 'amike-skip-link-focus-fix', get_theme_file_uri('/js/skip-link-focus-fix.js') , array('jquery'), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	wp_enqueue_script( 'amike-main', get_theme_file_uri() . '/js/main.js', array('jquery'), '1.0.0', true );
	//'amike-style' is main style of the theme
    wp_add_inline_style( 'amike-style', amike_inline_style());
}
add_action( 'wp_enqueue_scripts', 'amike_scripts' );

// Denqueue scripts and styles.
function amike_dequeue_script() {
    wp_dequeue_style( 'elementor-animations' );
    wp_deregister_style( 'elementor-animations' );
}
add_action( 'wp_enqueue_scripts', 'amike_dequeue_script', 20 );

//Exclude pages from WordPress Search
if (!is_admin()) {
	function amike_search_filter($query) {
		if ($query->is_search) {
			$query->set('post_type', 'post');
		}
		return $query;
	}
	add_filter('pre_get_posts','amike_search_filter');
}

// One click demo import
function amike_import_files() {
	return array(
		array(
			'import_file_name'             => __( 'Amike Demo', 'amike' ),
			'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/default/content.xml',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/default/widgets.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/default/customizer.dat',
			'local_import_redux'           => array(
				array(
					'file_path'   => trailingslashit( get_template_directory() ) . 'demo/redux.json',
					'option_name' => 'amike_opt',
				),
			),
			'import_preview_image_url'     => get_template_directory_uri(). '/demo/default/demo.jpg',
			'import_notice'                => __( 'After you import this demo, you will have to setup the slider separately.', 'amike' ),
			'preview_url'                  => 'https://themebing.com/wp/amike/',
		),
		array(
			'import_file_name'             => __( 'Amike Demo RTL', 'amike' ),
			'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/rtl/content.xml',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/rtl/widgets.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/rtl/customizer.dat',
			'local_import_redux'           => array(
				array(
					'file_path'   => trailingslashit( get_template_directory() ) . 'demo/redux.json',
					'option_name' => 'amike_opt',
				),
			),
			'import_preview_image_url'     => get_template_directory_uri(). '/demo/rtl/demo.jpg',
			'import_notice'                => __( 'After you import this demo, you will have to setup the slider separately.', 'amike' ),
			'preview_url'                  => 'https://themebing.com/wp/amike/rtl',
		)
	);
}


add_filter( 'pt-ocdi/import_files', 'amike_import_files' );

// Comment List
function amike_comment_list($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'article' == $args['style'] ) {
		$tag = 'article';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'comment';
	}
?>

<<?php echo esc_html( $tag ) ?> <?php comment_class(empty( $args['has_children'] ) ? '' :'parent') ?> id="comment-<?php comment_ID() ?>" itemscope itemtype="http://schema.org/Comment">
	<div class="single-comment row">
	    <div class="comment-avatar-img">
	        <?php echo get_avatar( $comment, 90, '', 'Author\'s gravatar' ); ?>
	    </div>
	    <div class="comment-text">
	        <div class="comment-avatar-info">
	            <h5><?php comment_author(); ?> <span class="comment-date"><?php comment_date('jS F Y , ').comment_time() ?></span></h5>
	            <?php comment_reply_link(array_merge( $args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
	        </div>
	        <?php comment_text() ?>
	        <?php if ($comment->comment_approved == '0') : ?>
			<p class="comment-meta-item">Your comment is awaiting moderation.</p>
			<?php endif; ?>
			<?php edit_comment_link('<p class="comment-meta-item">Edit this comment</p>','',''); ?>
	    </div>
	</div>
<?php }

// Default Home and Blog Setup
function amike_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'primary', 'primary' );

    set_theme_mod( 'nav_menu_locations', array(
            'main_menu' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );
}
add_action( 'pt-ocdi/after_import', 'amike_after_import_setup' );


// Entry footer
function amike_entry_footer() {
	if ('post' === get_post_type()) {
		$categories_list = get_the_category_list(esc_html__(', ', 'amike'));
		if ($categories_list) {
			printf('<span class="cat-links">' . esc_html__('Posted in %1$s', 'amike') . '</span>', $categories_list);
		}

		$tags_list = get_the_tag_list('', esc_html_x(', ', 'list item separator', 'amike'));
		if ($tags_list) {
			printf('<span class="tags-links">' . esc_html__('Tagged %1$s', 'amike') . '</span>', $tags_list);
		}
	}

	if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) {
		echo '<span class="comments-link">';
		comments_popup_link(sprintf(wp_kses(__('Leave a Comment<span class="screen-reader-text"> on %s</span>', 'amike') , array(
			'span' => array(
				'class' => array() ,
			) ,
		)) , get_the_title()));
		echo '</span>';
	}

	edit_post_link(sprintf(wp_kses(__('Edit <span class="screen-reader-text">%s</span>', 'amike') , array(
		'span' => array(
			'class' => array() ,
		) ,
	)) , get_the_title()) , '<span class="edit-link">', '</span>');
}


// required plugins

function amike_register_required_plugins() {
	
	$plugins = array(
		
		array(
			'name'      => esc_html__('Redux Framework', 'amike'),
			'slug'      => 'redux-framework',
			'required'  => true,
		),
		array(
			'name'      => esc_html__('Elementor Page Builder', 'amike'),
			'slug'      => 'elementor',
			'required'  => true,
		),
		array(
			'name'      => esc_html__('Amike Element', 'amike'),
			'slug'      => 'amike-element', 
			'source'    => 'https://github.com/themebing/amike-element/archive/master.zip', 
			'required'  => true
		),
		array(
			'name'      => esc_html__('Contact Form 7', 'amike'),
			'slug'      => 'contact-form-7',
			'required'  => true,
		),
		array(
			'name'      => esc_html__('One Click Demo Import', 'amike'),
			'slug'      => 'one-click-demo-import',
			'required'  => true,
		),
	);

	
	$config = array(
		'id'           => 'tgmpa',                 
		'default_path' => '',                      
		'menu'         => 'tgmpa-install-plugins', 
		'parent_slug'  => 'themes.php',            
		'capability'   => 'edit_theme_options',
		'has_notices'  => true,                    
		'dismissable'  => true,                    
		'dismiss_msg'  => '',     
		'is_automatic' => false, 
		'message'      => '',
	);

	tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'amike_register_required_plugins' );


// Category count on rightside
function amike_category_count_on_rightside($links) {
	$links = str_replace('</a> (', '<span class="float-right">(', $links);
	$links = str_replace(')', ')</span></a>', $links);
	return $links;
}
add_filter('wp_list_categories', 'amike_category_count_on_rightside');

// Add span to archive post count
function amike_style_the_archive_count($links) {
    $links = str_replace('</a>&nbsp;(', '<span class="float-right">(', $links);
    $links = str_replace(')', ')</span></a>', $links);
    return $links;
}

add_filter('get_archives_link', 'amike_style_the_archive_count');

// amike pagination
if ( ! function_exists ( 'amike_pagination' ) ) {

	function amike_pagination( $args = array(), $class = 'pagination' ) {

        if ($GLOBALS['wp_query']->max_num_pages <= 1) return;

		$args = wp_parse_args( $args, array(
			'mid_size'           => 2,
			'prev_next'          => true,
			'prev_text'          => esc_html__( '&laquo;', 'amike' ),
			'next_text'          => esc_html__( '&raquo;', 'amike' ),
			'screen_reader_text' => esc_html__( 'Posts navigation', 'amike' ),
			'type'               => 'array',
			'current'            => max( 1, get_query_var('paged') ),
		) );

        $links = paginate_links($args);

        ?>

        <nav aria-label="<?php echo esc_attr( $args['screen_reader_text'] ); ?>">

            <ul class="pagination">

                <?php

                    foreach ( $links as $key => $link ) { ?>

                        <li class="page-item <?php echo strpos( $link, 'current' ) ? 'active' : '' ?>">

                            <?php echo str_replace( 'page-numbers', 'page-link', $link ); ?>

                        </li>

                <?php } ?>

            </ul>

        </nav>

        <?php
    }
}


// amike Theme Customizer
function amike_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'amike_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'amike_customize_partial_blogdescription',
		) );
	}
}
add_action( 'customize_register', 'amike_customize_register' );

// Render the site title for the selective refresh partial.
function amike_customize_partial_blogname() {
	bloginfo( 'name' );
}

// Render the site tagline for the selective refresh partial.
function amike_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

// Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
function amike_customize_preview_js() {
	wp_enqueue_script( 'amike-customizer', get_theme_file_uri('/js/customizer.js') , array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'amike_customize_preview_js' );




function add_theme_scripts() {
  wp_enqueue_script( 'script', get_template_directory_uri() . '/js/toggle-menu.js', array ( 'jquery' ), 1.1, true); 
}
add_action( 'wp_enqueue_scripts', 'add_theme_scripts' );